#|_______________________________________________
 |
 | vismenu3.lsp 
 | HELP and DEVELOPERS MENUS
 | Copyright (c) 1991-2002 by Forrest W. Young
 |
 | Also contains original code for WINDOW menus
 | which has been replaced by code in vismenu4.lsp, and for
 | TOOL menu which was used with guidemaps which are defunct.
 |_______________________________________________
 |#

                                                
#|
 | DESKTOP WINDOW MENU
 |#

(setf *desktop-window-menu* (send menu-proto :new "Window"))

;----Desktop Window


 (setf *desktop-desktop-window-item* 
       (send menu-item-proto :new "DeskTop Window" :mark t
             :action 'vista-desktop-window))
 

;----XLispStat Window 1
(setf *main-menubar* T)

#|fwy moved to defun0.lsp 09-22-02
(defun xlispstat-window (&key (viva nil))
  (defaultmainwindow)
  (send *show-xlispstat-window-item* :mark t)
  (when viva (print-viva-listener-help))
  (when (and (not *main-menubar*) *devel-mode*) (main-menubar))
  )
|#

(setf *show-xlispstat-window-item*
      (send expert-menu-item-proto :new "XLispStat Window"
            :action #'(lambda () (xlispstat-window))))


;--- DataSheet Window

(defun datasheet-window ()
  (cond
    ((not *current-data*)
     (error-message "There is no data object"))
    (*current-datasheet*
     (send *current-datasheet* :front-window))
    (t
     (browse-data))))

;----SpreadPlot Window

(defun spreadplot-window () 
  (cond
    ((not *current-object*)
     (error-message "There is no statistical object"))
    (*spreadplot-container*
     (send *spreadplot-container* :show-window)
     (send *spreadplot-container* :front-window))
    ((equal *current-object* *current-data*)  (visualize-data))
    ((equal *current-object* *current-model*) (visualize-model))))
 
(setf *desktop-spreadplot-menu-item* 
      (send menu-item-proto :new "SpreadPlot Window"
            :enabled *current-spreadplot*
            :action 'spreadplot-window))

;----Report Window

(defun report-window () 
   (cond
     ((not *current-object*))
     ((equal *current-object* *current-data*) (summarize-data))
     ((equal *current-object* *current-model*) (report-model)))) 

(setf *desktop-report-menu-item* 
       (send menu-item-proto :new "Report Window" :enabled nil
             :action 'report-window))

 (setf *desktop-refresh-menu-item*
       (send menu-item-proto :new "Refresh DeskTop" :enabled t
             :action (lambda ()
                       (send *vista* :refresh-desktop 
                             :first-time nil :resize nil))))    



;----maximize workmap    0
;----maximize datasheet  1
;----maximize listener   2
;----restore layout      3

(defun maximize-workmap ()
  (remake-desktop-menu-items 0 1))

(defun maximize-datasheet ()
  (remake-desktop-menu-items 1 0))

(defun restore-layout ()
  (when (send *workmap* :popped-out?) (send *datasheet* :pop-out nil))
  (remake-desktop-menu-items 3 *default-workmap-proportion*))

(setf *max-workmap-item*
      (send expert-menu-item-proto :new "Maximize WorkMap"
            :action #'(lambda () (remake-desktop-menu-items 0 1))))

(setf *max-datasheet-item*
      (send expert-menu-item-proto :new "Maximize DataSheet"
            :action #'(lambda () (remake-desktop-menu-items 1 0))))

(setf *max-listener-item*
      (send expert-menu-item-proto :new "Maximize Listener"
            :action #'(lambda () (maximize-listener))))

(setf *restore-layout-item*
      (send expert-menu-item-proto :new "Restore Layout" :enabled nil
            :action #'(lambda () (restore-layout))))

(defun remake-desktop-menu-items (i p &optional (n *num-listener-lines*)) 
"i=0,1,2 or 3 for maxworkmap,maxdatasheet,maxlistener,restore"
  (let* ((items  (list *max-workmap-item* *max-datasheet-item* 
                       *max-listener-item* *restore-layout-item* ))
         (overlay (first (send *datasheet* :overlays)))
         (item))
    (flet ((switch-items (not-this-item) 
                         (mapcar #'(lambda (item) 
                                     (if (equal item not-this-item)
                                         (send item :enabled nil)
                                         (send item :enabled t)))
                                 items))
           )
      (setf *desktop-layout-state* i)
      (setf item (select items i))
      (switch-items item)
      (send *vista* :workmap-proportion p)
      (unless (= i 2)
              (send *show/hide-selector-item* :enabled t)
              (send *desktop-listener-item* :enabled t)
              (send *desktop-container* :make-desktop-container-resize)
              (setf *num-listener-lines* *default-num-listener-lines*)
              (setf *maximized-listener?* nil)
              )

      (case i
        (0 ;max workmap
           (send *datasheet* :bottom-most nil)
           (send *workmap* :top-most t)
           (send *varobs-obj* :bottom-most t)
           (send overlay :max-state t)
           (send overlay :setup-redraw)
           (send overlay :draw-button nil 3))
        (1 ;max datasheet
           (send *datasheet* :top-most t)
           (send *workmap* :bottom-most t)
           (send *varobs-obj* :bottom-most t)
           (send *show/hide-selector-item* :enabled nil)
           (send *desktop-listener-item* :enabled nil)
           (send overlay :max-state t)
           (send overlay :setup-redraw)
           (send overlay :draw-button nil 3))
        (2 ;max listener
           (send *desktop-container* :make-desktop-container-resize-for-maximized-listener)
           (send *datasheet* :bottom-most t)
           (send *workmap* :bottom-most t)
           (send *varobs-obj* :bottom-most t)
           (send *listener* :maximize)
           (setf *maximized-listener?* t)
           )
        (3 ;restore
           (send *datasheet* :top-most t)
           (send *workmap* :top-most t)
           (send *varobs-obj* :top-most t)
           (send overlay :max-state nil)
           (send overlay :setup-redraw)
           (send overlay :draw-button nil 3)
           (send *datasheet* :max-restore nil p)
           ))
      (unless (= i 2)
              (send *vista* :workmap-proportion p)
              (send *vista* :refresh-desktop :first-time nil :resize nil)
              )
      item)))	

;----show/hide selector Window

(defun show-selector ()
  (send *show/hide-selector-item* :title "Hide Selector")
  (send *vista* :show-varobs t)
  (send *desktop-container* :resize)
  )

(defun hide-selector ()
  (send *show/hide-selector-item* :title "Show Selector")
  (send *vista* :show-varobs nil)
  (send *desktop-container* :resize)
  )

(defun show/hide-selector ()
  (if (send *vista* :show-varobs)
      (hide-selector)
      (show-selector)))

(setf *show/hide-selector-item* 
      (send expert-menu-item-proto 
            :new "Hide Selector" 
            :enabled t
            :action #'show/hide-selector))

;----show/hide listener

(defun show/hide-desktop-listener ()
  (cond 
    ((equal "Hide Listener"
            (send *desktop-listener-item* :title))
     (hide-listener)
     (send *desktop-listener-item* :title "Show Listener"))
    (t
     (show-listener)
     (send *desktop-listener-item* :title "Hide Listener"))))

(defun show-listener ()
  (setf *num-listener-lines* *default-num-listener-lines*)
  (send *desktop-container* :resize))

(defun hide-listener ()
  (setf *num-listener-lines* 0)
  (send *desktop-container* :resize))

(setf *desktop-listener-item*
      (send expert-menu-item-proto :new "Hide Listener"
            :action #'(lambda () 
			(show/hide-desktop-listener))))
      
;----maximize desktop

(defun max-desk () (maximize-desktop))

(defun maximize-desktop ()
  (send *desktop-container* :maximize)
  (send *max-desk-item* :enabled nil)
  (send *restore-desktop-item* :enabled t)
  )

(setf *max-desk-item*
      (send expert-menu-item-proto :new "Maximize DeskTop" :enabled t
            :action #'maximize-desktop))

;----restore desktop

(setf *restore-desktop-item*
      (send expert-menu-item-proto :new "Restore Desktop" :enabled nil
            :action #'(lambda () (restore-desktop))))

(defun rest-desk () (restore-desktop ))

(defun restore-desktop ()
  (send *desktop-container* :restore)
  (send *max-desk-item* :enabled t)
  (setf *maximized-listener?* nil)
  (send *restore-desktop-item* :enabled nil)
  )

;----refresh desktop



;---menu

(setf *desktop-window-menu* (send menu-proto :new "Window"))


;----------------
;DEVELOPERS MENU
;----------------

#|
Date: 	Tue, 31 Mar 1998 14:37:17 -0400
From: kjetil halvorsen <kjetil@caoba.entelnet.bo>

modified extensively by FWY
|#
      
(setf *devel-menu* (send menu-proto :new "Develop"))
(setf *debug-menu* *devel-menu*)

(defun compile-changes () (compile-changed-vista-sources))

(setf compile-item (send menu-item-proto :new "Compile File ..."
                         :action #'(lambda () (compile-vista-base-file-dialog))))

(setf compile-all-item (send menu-item-proto :new "Compile"
                         :action #'(lambda () (compile-changed-vista-sources))))

(defun bugs-and-fixes ()
  (set-working-directory *default-path*)
  (system "lspedit.exe help\\help\\bugsfixs.hlp"))

(setf bugs-and-fixes-menu-item 
      (send menu-item-proto :new "Bugs and Fixes"
            :action 'bugs-and-fixes))
  
(setf baktracer-item 
      (send menu-item-proto :new "BakTracer"
            :action 'baktracer))
  
(defun to-do-list ()
  (send *vista* :file-to-help-window (strcat *help-dir-name* "to-do.hlp") "To Do List" *help-window*))

(setf to-do-menu-item
      (send menu-item-proto :new "To Do List"
            :action 'to-do-list))

(defun edit-to-do-list ()
  (set-working-directory *default-path*)
  (system "lspedit.exe help\\help\\to-do.hlp"))

(setf edit-to-do-menu-item
      (send menu-item-proto :new "Edit To Do List"
            :action 'edit-to-do-list))

(defun visible-startup-mode (&optional (logical nil set))
  (if set (setf *visible-startup* (not logical)))
  (visible-startup-toggle)
  ;(message-dialog (format nil "~a ~a ~a" logical set *visible-startup*))
  )

(defun visible-startup-toggle ()
  (cond 
    (*visible-startup*
     (setf *visible-startup* nil)
     (send see-startup-item :mark nil)
     (msw-write-profile-string "XLisp" "HideMainFrame" "Yes" *ini-file*))
                               ;(strcat *default-path* "wxls32.ini")
    (t
     (setf *visible-startup* t)
     (send see-startup-item :mark t)
     (msw-write-profile-string "XLisp" "HideMainFrame" "No" *ini-file*)))
                               ;(strcat *default-path* "wxls32.ini")
  *visible-startup*)

(setf see-startup-item (send menu-item-proto :new "Visible Startup"
                             :action #'visible-startup-mode :mark *visible-startup*))

(defun compile-vista () (restart-vista))

(setf compile-restart-item (send menu-item-proto :new "Compile ViSta"
                         :action #'compile-vista))
                           
(setf make-item (send menu-item-proto :new "Make ViSta"
                         :action #'make-vista))

(setf debug-item (send menu-item-proto :new "Debug Mode"
                        :action #'debug-toggle :mark *debug-mode*))  

(setf devel-item (send menu-item-proto :new "Devel Mode"
                       :action #'devel-mode :mark *devel-mode*))  
 
(setf verbose-item (send menu-item-proto :new "Verbosity Toggle"
                          :action #'verbosity-toggle
                         :mark (> *verbosity* 0)))

(setf update-prefs-item (send menu-item-proto :new "Update Pref Files"
                              :action #'update-pref-files))
  
(setf review-install-item (send menu-item-proto :new "Installation Summary"
                                :action #'installation-summary))
 
 (setf baktrace-item (send menu-item-proto :new "Baktrace 3 Levels"
                           :action #'(lambda () (baktrace 3))))
 
 (setf continue-item (send menu-item-proto :new "Continue"
                           :action #'continue))
 
 (setf trace-item (send menu-item-proto :new "Trace"
                        :action #'(lambda () (trace-dialog))))

(setf baktrace-functions-item (send menu-item-proto :new "BakTrace Functions"
                        :action #'(lambda () (baktrace-functions))))
 
 (setf version-item (send menu-item-proto :new "Version"
                          :action #'(lambda () (version))))

(setf untrace-item (send menu-item-proto :new "Untrace"
                          :action #'(lambda () (untrace))))
 

(setf report-datatypes-item (send menu-item-proto :new "Show DataTypes"
                      :action #'(lambda () (current-datatype))))

(setf report-filetypes-item (send menu-item-proto :new "Show FileTypes"
                      :action #'(lambda () (show-filetypes))))

 (defun symbol-editor ()
   (load (strcat *fsl-dir-name* "symedit"))
   )
 
 (defun bitmap-editor ()
   (load (strcat *fsl-dir-name* "editbmp"))
   (bitmap-editor))
 
 (setf bitmap-editor-item (send menu-item-proto :new "Bitmap Editor ..."
                                :action #'(lambda () (bitmap-editor))))
 
 (setf symbol-dialog-item (send menu-item-proto :new "Symbol Editor ..."
                                :action #'(lambda () (symbol-editor))))
 
 (setf working-directory-item (send menu-item-proto :new
       "Working Directory" :action #'(lambda () 
           (princ (get-working-directory))
                  (terpri))))
 
 (setf report-paths-item (send menu-item-proto :new
   "Show Paths" :action #'show-paths))
 
 (setf set-working-directory-item (send menu-item-proto :new
     "Set Working Directory" :action #'(lambda ()
     (print (set-working-directory 
             (get-string-dialog
              "Working directory name")))
     (terpri))))
 
 (defun report-front-window ()
   (send *watcher* :write-text 
         (format nil "~a" (if (front-window)
         (send (front-window) :title) nil))))
 (setf front-window-item (send menu-item-proto :new "Front Window"
                              :action #'report-front-window))

(setf exit-item (send menu-item-proto :new "Emergency Exit"
                      :action #'exit))

(setf stop-all-plots-menu-item (send menu-item-proto :new "Stop All Plots"
                      :action #'(lambda () (how-many-stopped))))

(setf devel-menu-toplevel-item
  (send menu-item-proto :new "Toplevel" :action #'top-level))
      (send *devel-menu* :append-items

          ;  bugs-and-fixes-menu-item
            to-do-menu-item
            edit-to-do-menu-item
           (send dash-item-proto :new)
            make-item
            compile-restart-item
            (send dash-item-proto :new)
            see-startup-item
            debug-item
            verbose-item
            (send dash-item-proto :new) 
            update-prefs-item 
            report-paths-item
            report-datatypes-item
            report-filetypes-item
            review-install-item
            version-item
          ;  (send dash-item-proto :new)
            (send dash-item-proto :new)
            baktracer-item
            baktrace-functions-item 
            baktrace-item
            (send dash-item-proto :new)
            trace-item
            untrace-item
            continue-item
            (send dash-item-proto :new)
            stop-all-plots-menu-item
            devel-menu-toplevel-item 
          ; (send dash-item-proto :new)
         ;  bitmap-editor-item 
         ;  symbol-dialog-item 
            (send dash-item-proto :new)
            front-window-item 
            working-directory-item 
            set-working-directory-item
    #+msdos (send dash-item-proto :new)
    #+msdos exit-item
            )

;(add-distribution-item)




#|_________________________________________________________________
 |
 | HELP MENU
 |_________________________________________________________________
 |#


;WELCOME
(defun welcome-panel () (welcome-control-panel 0 0 t))

(setf help-menu-WELCOME-item
      (send menu-item-proto :new "Welcome to ViSta"
            :action 'welcome-to-vista-))


; HELP TOPICS

(setf help-menu-help-topics-item
      (send menu-item-proto :new "Help Topics" 
            :action 'help-topics))


;MENU ITEM HELP
;USING THE MENUS (used by subtopic)

(setf help-menu-about-menus-help-item
      (send menu-item-proto :new "Using The Menus"
            :action 'using-the-menus))

(setf help-menu-menu-help-item help-menu-about-menus-help-item)
(setf help-menu-using-the-menus-help-item help-menu-about-menus-help-item)

(defun about-the-menus () (using-the-menus))
(defun menu-help       () (using-the-menus))
(defun show-menu-help  () (using-the-menus))

(setf help-menu-menu-item-help-item
      (send expert-menu-item-proto :new "Menu Item Help"
            :action 'menu-item-help))

(setf  help-menu-menu-item-help help-menu-menu-item-help-item)
(defun menu-item-help   () (menu-item-help-control-panel))
(defun about-menu-items () (when *vista* (send *vista* :set-menu-help-mode)))
(defun show-menu-help   () (when *vista* (send *vista* :set-menu-help-mode)))

;PRINT ALL HELP TOPICS

(defun print-all-help-topics ()
  (when
   (two-button-dialog (format nil "Are You Sure?~%~%There are 100 printed pages!")
                      :first-button "Yes - Please Print" 
                      :second-button "No - Save A Tree!")
   (print-help-topics)))

(setf help-menu-print-help-item
       (send expert-menu-item-proto :new "Print All Help Topics"
             :action 'print-all-help-topics))

;DOCUMENTATION FILES

;fwy changed 09-27-02 to avoid conflict with XLisp documentation function
;(defun documentation ()
;  (set-working-directory (strcat *default-path* "help\\doco"))
;  (read-file-dialog t))


(setf help-menu-doco-files-item
      (send expert-menu-item-proto :new "Documentation" 
            :action 'documentation))

;DEMONSTRATIONS

(defun demonstrations ()
  (load (strcat *default-path* "help\\demos\\demos.lsp")))

(setf help-menu-demonstrations-help-item
      (send expert-menu-item-proto :new "Demonstrations"
            :action 'demonstrations))

;ViSTA ONLINE

(setf help-menu-web-help-item
      (send expert-menu-item-proto :new "ViSta OnLine"
            :action #'vista-online))


;ABOUT VISTA
 (setf help-menu-about-vista-help-item
      (send expert-menu-item-proto :new "About ViSta"
            :action 'about-vista ))

;COPYRIGHTS

(defun show-copyrights () (show-pretty-copyrights))

(setf help-menu-copyrights-item
      (send expert-menu-item-proto :new "Show Copyrights"
            :action #'show-copyrights))


;ANIMATIONS (NOT USED)
(setf help-menu-animations-help-item
      (send menu-item-proto :new "Animations"
            :action 'animations))


;EXCEL AND VISTA (NOT USED BY MENUS - REPLACED BY SUBTOPIC)
(setf help-menu-using-excel-help-item
      (send menu-item-proto :new "Excel and ViSta"
            :action 'excel-and-vista))
 
;ENTERING DATA (NOT USED BY MENUS - REPLACED BY SUBTOPIC)
(setf help-menu-entering-data-help-item
      (send menu-item-proto :new "Entering Data"
            :action 'entering-data))

;MANAGING DATA (NOT USED BY MENUS - REPLACED BY SUBTOPIC)

(defun managing-data () (manipulating-data))
(setf help-menu-manipulating-data-help-item
      (send menu-item-proto :new "Managing Data"
            :action 'manipulating-data ))

;ON STATISTICS (NOT USED BY MENUS - REPLACED BY SUBTOPIC)
(setf help-menu-on-statistics-item
      (send menu-item-proto :new "On Statistics"
            :action 'on-statistics))


;USING THE DESKTOP (NOT USED BY MENUS - REPLACED BY SUBTOPIC)
(setf help-menu-using-the-desktop-help-item
      (send menu-item-proto :new "Using The Desktop"
            :action 'using-the-desktop))

;USING THE MENUS (NOT USED BY MENUS - REPLACED BY SUBTOPIC)
(setf help-menu-about-menus-help-item
      (send menu-item-proto :new "Using The Menus"
            :action 'using-the-menus))


;HELP MENU

(defvar *help-menu* (send menu-proto :new "Help"))
(send   *help-menu* :enabled t)
(send   *help-menu* :append-items
        help-menu-welcome-item
        (send dash-item-proto :new)
        help-menu-help-topics-item
        help-menu-menu-item-help-item
        help-menu-print-help-item
      ; (send dash-item-proto :new)
      ; help-menu-doco-files-item
        help-menu-demonstrations-help-item
        (send dash-item-proto :new)
        help-menu-web-help-item 
        (send dash-item-proto :new)
        help-menu-about-vista-help-item 
        help-menu-copyrights-item
        )




;----------------
;TOOL MENU
;----------------

(defvar *expert-menu* (send menu-proto :new "Tools"))

(setf link-icon-expert-menu-item
      (send menu-item-proto :new "Auto LINK Icon" :enabled t
            :action 'auto-link-icon))

(setf return-icon-expert-menu-item
      (send menu-item-proto :new "Auto RETURN Icon" :enabled t
            :action 'auto-return-icon))

(setf link-button-expert-menu-item
      (send menu-item-proto :new "LINK Button" :enabled t
            :action 'link-button))

(setf return-button-expert-menu-item
      (send menu-item-proto :new "RETURN Button" :enabled t
            :action 'return-button))

(setf goto-button-expert-menu-item
      (send menu-item-proto :new "GOTO Button" :enabled t
            :action 'goto-button))

(setf and-icon-expert-menu-item
      (send menu-item-proto :new "AND Icon" :enabled t
            :action 'and-icon))

(setf connect-icons-expert-menu-item
      (send menu-item-proto :new "Connect Objects" :enabled t
            :action 'connect-objects))

(setf active-icon-expert-menu-item
      (send menu-item-proto :new "Initial Button" :enabled t
            :action #'(lambda () (send *expertmap* :initial-button))))

(setf save-expert-menu-item
      (send menu-item-proto :new "Save Author Map" :enabled t
            :action #'(lambda () (send *expertmap* :save-workmap))))

(send *expert-menu* :append-items
      and-icon-expert-menu-item
      link-icon-expert-menu-item
      return-icon-expert-menu-item
      (send dash-item-proto :new)
      link-button-expert-menu-item
      return-button-expert-menu-item
      goto-button-expert-menu-item
      (send dash-item-proto :new)
      connect-icons-expert-menu-item
      active-icon-expert-menu-item
      (send dash-item-proto :new)
      save-expert-menu-item)


